/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.service.managedsystem.refcode.config;

import com.ibm.hwmca.fw.service.config.ClassData;
import com.ibm.hwmca.fw.service.config.XMLMapParser;
import com.ibm.hwmca.fw.service.managedsystem.refcode.RefCode;
import com.ibm.hwmca.fw.util.CommonXMLParser;
import com.ibm.hwmca.fw.util.MalformedXMLException;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.fw.util.XMLParsingException;
import java.io.File;
import java.io.FileInputStream;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public class RefCodeConfigParser
extends XMLMapParser {
    private static final String TRACE_MASKT = "XRVFxxxT";
    private static final String TRACE_MASKF = "XRVFxxxF";
    private static final String TRACE_MASKD = "XRVFxxxD";
    private static final String TAG_REFCODE_CONFIG = "refcode-config";
    private static final String TAG_REFCODE = "refcode";
    private static final String TAG_ISOLATE = "isolate";
    private static final String TAG_RECREATE = "recreate";
    private static final String TAG_DESC = "desc";
    private static final String ATTRIB_NAME = "name";
    private static final String ATTRIB_REQUIRED = "required";

    public RefCodeConfigParser() throws SAXNotRecognizedException, SAXNotSupportedException {
        this.setFeature("http://xml.org/sax/features/validation", true);
        this.setErrorHandler(this);
    }

    public Map parseXML(String xmlFile) throws XMLParsingException {
        return this.parseXML(new File(xmlFile));
    }

    public Map parseXML(File file) throws XMLParsingException {
        Trace.trace(TRACE_MASKD, "RefCodeConfigParser parsing file: " + file);
        Map parsedData = null;
        try {
            this.parse(new InputSource(new FileInputStream(file)));
            Document doc = this.getDocument();
            NodeList nodeList = doc.getElementsByTagName(TAG_REFCODE_CONFIG);
            if (nodeList != null) {
                parsedData = RefCodeConfigParser.parseRefcodes(nodeList.item(0));
            }
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKD, "<-! RefCodeConfigParser.parseXML Exception caught: " + e);
            Trace.trace(TRACE_MASKD, e);
            if (e instanceof XMLParsingException) {
                throw (XMLParsingException)e;
            }
            throw new XMLParsingException(e);
        }
        return parsedData;
    }

    private static Map parseRefcodes(Node nodeToParse) throws MalformedXMLException {
        HashMap<String, RefCode> parsedData = new HashMap<String, RefCode>();
        NodeList nodes = nodeToParse.getChildNodes();
        int aii = 0;
        while (aii < nodes.getLength()) {
            Node node = nodes.item(aii);
            if (node.getNodeType() == 1 && node.getNodeName().toLowerCase().equals(TAG_REFCODE)) {
                RefCode refcode = new RefCode(node.getAttributes().getNamedItem(ATTRIB_NAME).getNodeValue());
                NodeList subnodes = node.getChildNodes();
                int bii = 0;
                while (bii < subnodes.getLength()) {
                    Node subnode = subnodes.item(bii);
                    if (subnode.getNodeType() == 1) {
                        boolean required;
                        String tag = subnode.getNodeName().toLowerCase();
                        if (tag.equals(TAG_DESC)) {
                            refcode.setDesc(CommonXMLParser.gatherTextContents(subnode));
                        } else if (tag.equals(TAG_ISOLATE)) {
                            required = subnode.getAttributes().getNamedItem(ATTRIB_REQUIRED) == null ? true : Boolean.valueOf(subnode.getAttributes().getNamedItem(ATTRIB_REQUIRED).getNodeValue());
                            refcode.setIsolate(ClassData.parseClassDef(subnode), required);
                        } else if (tag.equals(TAG_RECREATE)) {
                            required = subnode.getAttributes().getNamedItem(ATTRIB_REQUIRED) == null ? true : Boolean.valueOf(subnode.getAttributes().getNamedItem(ATTRIB_REQUIRED).getNodeValue());
                            refcode.setRecreate(ClassData.parseClassDef(subnode), required);
                        }
                    }
                    ++bii;
                }
                Trace.trace(TRACE_MASKF, "RefCodeConfigParser.parseRefcodes:adding refcode:" + refcode);
                parsedData.put(refcode.getRefCodeString(), refcode);
            }
            ++aii;
        }
        return parsedData;
    }
}

